/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseUtil {
    private static final String DEV_VERSION = "0.0.0.qualifier";
    private static final String APTANA_STUDIO_PREFIX = "Aptana";
    private static final String APTANA_STUDIO = MessageFormat.format("{0} Studio", "Aptana");
    private static final Pattern VERSION_PATTERN = Pattern.compile("Version: (.*)\n");
    private static final Pattern VERSION_4_4_PATTERN = Pattern.compile("Version: \\{1\\} \\((.*)\\)\n");
    private static final Pattern BUILD_PATTERN = Pattern.compile("build: (.*)\n");
    private static final Pattern BUILD_BRANCH_PATTERN = Pattern.compile("Build: ([\\w\\-\\d]+) \\(origin/(\\w+)\\)\n");
    public static final String STANDALONE_PLUGIN_ID = "com.aptana.rcp";
    private static final String TYCHO_HEADLESS = "org.eclipse.tycho.surefire.osgibooter.headlesstest";
    private static final String TYCHO_UI = "org.eclipse.tycho.surefire.osgibooter.uitest";
    private static final String[] UNIT_TEST_IDS = new String[]{"org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.test.uitestapplication", "org.eclipse.pde.junit.runtime.legacytestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.pde.junit.runtime.coretestapplicationnonmain", "org.eclipse.pde.junit.runtime.nonuithreadtestapplication", "org.eclipse.tycho.surefire.osgibooter.headlesstest", "org.eclipse.tycho.surefire.osgibooter.uitest"};
    static final String[] LAUNCHER_NAMES = new String[]{"Eclipse", "AptanaStudio3", "Aptana Studio 3", "TitaniumStudio", "Titanium Studio"};
    private static Boolean isTesting;
    private static String rcpPluginId;
    private static String versionPluginId;
    private static String fgPrefix;
    private static Boolean fgNewAPI;

    static {
        rcpPluginId = STANDALONE_PLUGIN_ID;
        versionPluginId = "com.aptana.branding";
    }

    private EclipseUtil() {
    }

    public static boolean isDebugOptionEnabled(String option) {
        return Boolean.valueOf(Platform.getDebugOption((String)option));
    }

    public static boolean isSystemPropertyEnabled(String option) {
        return EclipseUtil.getSystemProperty(option) != null;
    }

    public static String getSystemProperty(String option) {
        if (option == null) {
            return null;
        }
        return System.getProperty(option);
    }

    public static String getSystemProperty(String option, String defaultValue) {
        if (option == null) {
            return null;
        }
        return System.getProperty(option, defaultValue);
    }

    public static boolean isPluginLoaded(Plugin plugin) {
        return plugin != null && plugin.getBundle() != null;
    }

    public static String getPluginVersion(Plugin plugin) {
        if (!EclipseUtil.isPluginLoaded(plugin)) {
            return null;
        }
        return EclipseUtil.getPluginVersion(plugin.getBundle());
    }

    public static String getPluginVersion(String pluginId) {
        if (pluginId == null) {
            return null;
        }
        return EclipseUtil.getPluginVersion(Platform.getBundle((String)pluginId));
    }

    private static String getPluginVersion(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return ((String)bundle.getHeaders().get("Bundle-Version")).toString();
    }

    public static String getProductName() {
        String name;
        IProduct product = Platform.getProduct();
        if (product != null && !StringUtil.isEmpty(name = product.getName())) {
            return name;
        }
        return APTANA_STUDIO;
    }

    public static String getProductVersion() {
        try {
            String aboutText = EclipseUtil.getProductProperty("aboutText");
            if (!StringUtil.isEmpty(aboutText)) {
                String version;
                Matcher m = VERSION_4_4_PATTERN.matcher(aboutText);
                if (m.find()) {
                    return Version.parseVersion((String)m.group(1)).toString();
                }
                m = VERSION_PATTERN.matcher(aboutText);
                if (m.find()) {
                    return m.group(1);
                }
                m = BUILD_PATTERN.matcher(aboutText);
                if (m.find() && !DEV_VERSION.equals(version = m.group(1))) {
                    return version;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EclipseUtil.getStudioVersion();
    }

    public static String getStudioVersion() {
        Bundle bundle = Platform.getBundle((String)versionPluginId);
        if (bundle != null) {
            return bundle.getVersion().toString();
        }
        return "";
    }

    public static synchronized String getStudioPrefix() {
        if (fgPrefix == null) {
            fgPrefix = APTANA_STUDIO_PREFIX;
            String name = EclipseUtil.getProductProperty("studioPrefix");
            if (!StringUtil.isEmpty(name)) {
                fgPrefix = name;
            }
        }
        return fgPrefix;
    }

    private static String getProductProperty(String propName) {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return null;
        }
        return product.getProperty(propName);
    }

    public static boolean isStandalone() {
        return EclipseUtil.getPluginVersion(rcpPluginId) != null;
    }

    public static boolean isTesting() {
        if (isTesting != null) {
            return isTesting;
        }
        String application = EclipseUtil.getApplicationId();
        if (application != null) {
            String[] stringArray = UNIT_TEST_IDS;
            int n = UNIT_TEST_IDS.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id.equals(application)) {
                    isTesting = Boolean.TRUE;
                    return isTesting;
                }
                ++n2;
            }
        }
        String[] args = EclipseUtil.getCommandLineArgs();
        isTesting = ArrayUtil.contains(args, "-testLoaderClass");
        return isTesting;
    }

    static String getApplicationId() {
        String application = EclipseUtil.getEnvironmentOrSystemProperty("eclipse.application");
        if (application != null) {
            return application;
        }
        application = EclipseUtil.getCommandLineArgValue("-application");
        return application;
    }

    private static String getCommandLineArgValue(String switchName) {
        String[] args = EclipseUtil.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (switchName.equals(args[i]) && i + 1 < args.length) {
                return args[i + 1];
            }
            ++i;
        }
        return null;
    }

    private static String getEnvironmentOrSystemProperty(String propName) {
        String value = null;
        EnvironmentInfo info = EclipseUtil.getEnvironmentInfo();
        if (info != null) {
            value = info.getProperty(propName);
        }
        if (value != null) {
            return value;
        }
        return System.getProperty(propName);
    }

    private static String[] getCommandLineArgs() {
        EnvironmentInfo info = EclipseUtil.getEnvironmentInfo();
        if (info != null) {
            return info.getCommandLineArgs();
        }
        String cmdline = EclipseUtil.getEnvironmentOrSystemProperty("eclipse.commands");
        if (cmdline != null && cmdline.length() > 0) {
            return cmdline.split("\n");
        }
        return ArrayUtil.NO_STRINGS;
    }

    public static IPath getApplicationLauncher() {
        return EclipseUtil.getApplicationLauncher(false);
    }

    public static IPath getApplicationLauncher(boolean asSplashLauncher) {
        String[] executableFiles;
        Location location;
        IPath launcher;
        String launcherName = EclipseUtil.getCommandLineArgValue("-launcher");
        IPath iPath = launcher = launcherName == null ? null : Path.fromOSString((String)launcherName);
        if (launcher == null && (location = Platform.getInstallLocation()) != null && (launcher = new Path(location.getURL().getFile())).toFile().isDirectory() && (executableFiles = launcher.toFile().list(new LauncherFilter())).length > 0) {
            launcher = launcher.append(executableFiles[0]);
        }
        if (launcher == null || !launcher.toFile().exists()) {
            return null;
        }
        if (PlatformUtil.isMac() && asSplashLauncher) {
            launcher = new Path(PlatformUtil.getApplicationExecutable(launcher.toOSString()).getAbsolutePath());
        }
        return launcher;
    }

    public static void setRCPPluginId(String pluginId) {
        if (!StringUtil.isEmpty(pluginId)) {
            rcpPluginId = pluginId;
        }
    }

    public static void setVersionPluginId(String pluginId) {
        if (!StringUtil.isEmpty(pluginId)) {
            versionPluginId = pluginId;
        }
    }

    public static boolean showSystemJobs() {
        return Platform.getPreferencesService().getBoolean("com.aptana.core", "show_system_jobs", false, null);
    }

    public static void setSystemForJob(Job job) {
        try {
            job.setSystem(!EclipseUtil.showSystemJobs());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setPlatformDebugging(boolean debugEnabled) {
        EnvironmentInfo info;
        String propertyName = "osgi.debug";
        if (!debugEnabled && !EclipseUtil.isNewOSGIAPI()) {
            try {
                Class<?> klazz = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkProperties");
                Method m = klazz.getMethod("clearProperty", String.class);
                m.invoke(null, "osgi.debug");
                return;
            }
            catch (ClassNotFoundException klazz) {
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
            }
        }
        if ((info = EclipseUtil.getEnvironmentInfo()) != null) {
            if (debugEnabled) {
                info.setProperty("osgi.debug", Boolean.toString(debugEnabled));
            } else {
                info.setProperty("osgi.debug", null);
            }
        }
    }

    protected static EnvironmentInfo getEnvironmentInfo() {
        BundleContext context = CorePlugin.getDefault().getContext();
        if (context == null) {
            return null;
        }
        ServiceReference ref = context.getServiceReference(EnvironmentInfo.class);
        if (ref == null) {
            return null;
        }
        return (EnvironmentInfo)context.getService(ref);
    }

    private static synchronized boolean isNewOSGIAPI() {
        if (fgNewAPI == null) {
            Bundle b = Platform.getBundle((String)"org.eclipse.osgi");
            Version v = b.getVersion();
            fgNewAPI = v.compareTo(Version.parseVersion((String)"3.9.100")) >= 0;
        }
        return fgNewAPI;
    }

    public static Map<String, String> getTraceableItems() {
        Bundle[] bundles;
        HashMap<String, String> stringModels = new HashMap<String, String>();
        BundleContext context = CorePlugin.getDefault().getContext();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Properties props = EclipseUtil.getTraceOptions(bundle);
            for (Object obj : props.keySet()) {
                String key = obj.toString();
                stringModels.put(key, props.getProperty(key));
            }
            ++n2;
        }
        return stringModels;
    }

    public static Properties getTraceOptions(Bundle bundle) {
        Path path = new Path(".options");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (fileURL != null) {
            try {
                InputStream in = fileURL.openStream();
                Properties options = new Properties();
                options.load(in);
                return options;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Properties();
    }

    public static Map<String, BundleContext> getCurrentBundleContexts() {
        Bundle[] bundles;
        HashMap<String, BundleContext> contexts = new HashMap<String, BundleContext>();
        BundleContext context = CorePlugin.getDefault().getContext();
        contexts.put(context.getBundle().getSymbolicName(), context);
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            BundleContext bContext = bundle.getBundleContext();
            if (bContext != null) {
                contexts.put(bundle.getSymbolicName(), bContext);
            }
            ++n2;
        }
        return contexts;
    }

    public static void setBundleDebugOptions(String[] currentOptions, boolean debugEnabled) {
        Map<String, BundleContext> bundles = EclipseUtil.getCurrentBundleContexts();
        String[] stringArray = currentOptions;
        int n = currentOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String symbolicName = key.substring(0, key.indexOf(47));
            BundleContext bundleContext = bundles.get(symbolicName);
            if (bundleContext != null) {
                ServiceReference sRef = bundleContext.getServiceReference(DebugOptions.class.getName());
                DebugOptions options = (DebugOptions)bundleContext.getService(sRef);
                if (debugEnabled) {
                    options.setDebugEnabled(debugEnabled);
                    options.setOption(key, Boolean.toString(debugEnabled));
                } else {
                    options.setOption(key, Boolean.toString(debugEnabled));
                    options.setDebugEnabled(debugEnabled);
                }
            }
            ++n2;
        }
    }

    public static String[] getCurrentDebuggableComponents() {
        String checked = Platform.getPreferencesService().getString("com.aptana.core", "pref_debug_component_list", null, null);
        if (checked != null) {
            return checked.split(",");
        }
        return ArrayUtil.NO_STRINGS;
    }

    public static void processConfigurationElements(String pluginId, String extensionPointId, IConfigurationElementProcessor processor) {
        IExtensionPoint extensionPoint = EclipseUtil.getExtensionPoint(pluginId, extensionPointId);
        if (extensionPoint != null) {
            EclipseUtil.processElements(extensionPoint, processor);
        }
    }

    public static IExtensionPoint getExtensionPoint(String pluginId, String extensionPointId) {
        if (StringUtil.isEmpty(pluginId) || StringUtil.isEmpty(extensionPointId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Geting Extension Point for {0} and extensionPoint {1} from {2}", pluginId, extensionPointId, registry), "com.aptana.core/debug/extension_points");
            return registry.getExtensionPoint(pluginId, extensionPointId);
        }
        return null;
    }

    public static void processElements(IExtensionPoint extensionPoint, IConfigurationElementProcessor processor) {
        if (processor == null || processor.getSupportElementNames().isEmpty()) {
            return;
        }
        Set<String> elementNames = processor.getSupportElementNames();
        IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Extension point : {0} and elements : {1}", extensionPoint, StringUtil.join(",", elementNames)), "com.aptana.core/debug/extension_points");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (String elementName : elementNames) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(elementName)) {
                        processor.processElement(element);
                        if (IdeLog.isTraceEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/extension_points")) {
                            IdeLog.logTrace(CorePlugin.getDefault(), MessageFormat.format("Processing extension element {0} with attributes {1}", element.getName(), EclipseUtil.collectElementAttributes(element)), "com.aptana.core/debug/extension_points");
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static Map<String, String> collectElementAttributes(IConfigurationElement element) {
        String[] attributes;
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] stringArray = attributes = element.getAttributeNames();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            map.put(string, element.getAttribute(string));
            ++n2;
        }
        return map;
    }

    public static URL getResourceURL(IConfigurationElement element, String attr) {
        String iconPath = element.getAttribute(attr);
        if (iconPath == null) {
            return null;
        }
        if (!iconPath.matches("\\p{Alpha}[\\p{Alnum}+.-]*:.*")) {
            String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
            iconPath = "platform:/plugin/" + extendingPluginId + "/" + iconPath;
        }
        try {
            return new URL(iconPath);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void migratePreference(String pluginId, String preferenceKey) {
        IEclipsePreferences instanceNode;
        String instancePrefValue;
        IEclipsePreferences configNode = ConfigurationScope.INSTANCE.getNode(pluginId);
        if (StringUtil.isEmpty(configNode.get(preferenceKey, null)) && !StringUtil.isEmpty(instancePrefValue = (instanceNode = InstanceScope.INSTANCE.getNode(pluginId)).get(preferenceKey, null))) {
            configNode.put(preferenceKey, instancePrefValue);
            instanceNode.remove(preferenceKey);
            try {
                configNode.flush();
                instanceNode.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), e.getMessage(), e);
            }
        }
    }

    static String getProductBuildBranch(String aboutText) {
        block4: {
            if (!StringUtil.isEmpty(aboutText)) break block4;
            return null;
        }
        try {
            Matcher m = BUILD_BRANCH_PATTERN.matcher(aboutText);
            if (m.find()) {
                return m.group(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getProductBuildBranch() {
        return EclipseUtil.getProductBuildBranch(EclipseUtil.getProductProperty("aboutText"));
    }

    public static boolean isTycho() {
        String appId = EclipseUtil.getApplicationId();
        return TYCHO_HEADLESS.equals(appId) || TYCHO_UI.equals(appId);
    }

    protected static final class LauncherFilter
    implements FilenameFilter {
        protected LauncherFilter() {
        }

        public boolean accept(File dir, String name) {
            IPath path = Path.fromOSString((String)dir.getAbsolutePath()).append(name);
            name = path.removeFileExtension().lastSegment();
            String ext = path.getFileExtension();
            if ("macosx".equals(Platform.getOS()) && !"app".equals(ext)) {
                return false;
            }
            String[] stringArray = LAUNCHER_NAMES;
            int n = LAUNCHER_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String launcherName = stringArray[n2];
                if (launcherName.equalsIgnoreCase(name)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

